<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSocialLinkTable extends Migration {

	public function up()
	{
		Schema::create('social_link', function(Blueprint $table) {
			$table->increments('id');
			$table->string('service_name', 20);
			$table->string('url', 150);
			$table->tinyInteger('status')->default('0');
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('social_link');
	}
}