<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 100);
			$table->string('uri', 100)->unique()->nullable();
			$table->string('website', 100)->nullable();
			$table->string('email', 100)->nullable();
			$table->string('logo_photo_path', 150)->nullable();
			$table->string('cover_photo_path', 150)->nullable();
			$table->string('address', 250)->nullable();
			$table->string('latitude', 30)->nullable();
			$table->string('longitude', 30)->nullable();
			$table->string('company_type', 30)->nullable();
			$table->string('business_type', 30)->nullable();
			$table->date('established_date')->nullable();
			$table->text('about_company')->nullable();
			$table->string('phone_number', 20)->nullable();
			$table->boolean('is_verified')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}