<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersInfoTable extends Migration {

	public function up()
	{
		Schema::create('users_info', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('email', 120)->nullable();
			$table->string('location', 200)->nullable();
			$table->string('latitude', 30)->nullable();
			$table->string('longitude', 30)->nullable();
			$table->string('mobile', 20)->nullable();
			$table->string('url', 150)->nullable();
			$table->text('objective')->nullable();
			$table->string('nid', 100)->nullable();
			$table->string('passport', 100)->nullable();
			$table->string('driving_license', 100)->nullable();
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users_info');
	}
}