<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 100);
			$table->string('email', 100)->unique();
			$table->string('username', 50)->unique();
			$table->string('password', 60);
			$table->tinyInteger('status')->default('0');
			$table->string('role', 20)->default('user');
			$table->string('photo_path', 150);
			$table->string('cover_photo_path', 150);
			$table->date('birth_date')->nullable();
			$table->string('activation_token', 100);
			$table->string('remember_token', 100);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}