<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Company extends Eloquent {

	protected $table = 'companies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsToMany('App\Models\User', 'company_associate_users', 'company_id', 'user_id');
	}

	public function job()
	{
		return $this->hasMany('App\Models\Job', 'company_id');
	}

	public function events()
	{
		return $this->hasMany('App\Models\Event', 'hosted_by');
	}

}