<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Status extends Eloquent {

	protected $table = 'status';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function comments()
	{
		return $this->hasMany('App\Models\Comment', 'status_id');
	}

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

}