<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function status()
	{
		return $this->hasMany('App\Models\Status', 'user_id');
	}

	public function company()
	{
		return $this->belongsToMany('App\Models\Company', 'company_associate_users', 'user_id', 'company_id');
	}

	public function onDemandHire()
	{
		return $this->hasOne('App\Models\OnDemandHire', 'user_id');
	}

	public function info()
	{
		return $this->hasOne('App\Models\UserInfo', 'user_id');
	}

	public function education()
	{
		return $this->hasMany('App\Models\Education', 'user_id');
	}

	public function work()
	{
		return $this->hasMany('App\Models\Work', 'user_id');
	}

	public function socialLink()
	{
		return $this->hasMany('App\Models\SocialLink', 'user_id');
	}

}