<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEducationsTable extends Migration {

	public function up()
	{
		Schema::create('educations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 80);
			$table->string('institute', 150);
			$table->string('start_at', 25)->nullable();
			$table->string('end_at', 25)->nullable();
			$table->string('major', 80)->nullable();
			$table->float('gpa', 1,2)->nullable();
			$table->string('location', 100)->nullable();
			$table->string('url', 100)->nullable();
			$table->tinyInteger('status')->nullable();
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('educations');
	}
}