<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOnDemandHireTable extends Migration {

	public function up()
	{
		Schema::create('on_demand_hire', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->tinyInteger('availability')->default('0');
			$table->string('available_days', 100)->nullable();
			$table->integer('hourly_rate')->default('0');
			$table->integer('minimum_rate')->default('0');
			$table->text('notes');
			$table->tinyInteger('status')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('on_demand_hire');
	}
}