<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('status', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('status')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company_associate_users', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company_associate_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('networks', function(Blueprint $table) {
			$table->foreign('following_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('networks', function(Blueprint $table) {
			$table->foreign('follower_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('hosted_by')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('event_participant', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('event_participant', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_info', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('educations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('works', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('works', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('social_link', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('status', function(Blueprint $table) {
			$table->dropForeign('status_user_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_status_id_foreign');
		});
		Schema::table('company_associate_users', function(Blueprint $table) {
			$table->dropForeign('company_associate_users_company_id_foreign');
		});
		Schema::table('company_associate_users', function(Blueprint $table) {
			$table->dropForeign('company_associate_users_user_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_company_id_foreign');
		});
		Schema::table('networks', function(Blueprint $table) {
			$table->dropForeign('networks_following_id_foreign');
		});
		Schema::table('networks', function(Blueprint $table) {
			$table->dropForeign('networks_follower_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_hosted_by_foreign');
		});
		Schema::table('event_participant', function(Blueprint $table) {
			$table->dropForeign('event_participant_event_id_foreign');
		});
		Schema::table('event_participant', function(Blueprint $table) {
			$table->dropForeign('event_participant_user_id_foreign');
		});
		Schema::table('users_info', function(Blueprint $table) {
			$table->dropForeign('users_info_user_id_foreign');
		});
		Schema::table('educations', function(Blueprint $table) {
			$table->dropForeign('educations_user_id_foreign');
		});
		Schema::table('works', function(Blueprint $table) {
			$table->dropForeign('works_company_id_foreign');
		});
		Schema::table('works', function(Blueprint $table) {
			$table->dropForeign('works_user_id_foreign');
		});
		Schema::table('social_link', function(Blueprint $table) {
			$table->dropForeign('social_link_user_id_foreign');
		});
	}
}