<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('con_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('parent_id')->nullable()->index();
			$table->string('slag', 255);
			$table->bigInteger('image_id')->nullable();
			$table->tinyInteger('active');
			$table->string('language', 5)->nullable();
			$table->string('country', 5)->nullable();
			$table->timestamps();
			$table->string('title', 255);
			$table->string('description', 500)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('con_categories');
	}
}