<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConReservationsTable extends Migration {

	public function up()
	{
		Schema::create('con_reservations', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->index();
			$table->timestamp('start_date');
			$table->timestamp('finish_date');
			$table->bigInteger('expert_id')->unsigned()->index();
			$table->timestamp('canceled_at')->nullable();
			$table->string('canceled_by', 255);
			$table->string('status', 255)->nullable();
			$table->bigInteger('package_id')->nullable()->index();
			$table->bigInteger('service_id')->nullable()->index();
			$table->bigInteger('host_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('con_reservations');
	}
}