<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->integer('brand_id')->unsigned();
			$table->string('price');
			$table->float('old_price');
			$table->integer('action_id')->unsigned();
			$table->tinyInteger('availability');
			$table->string('is_new');
			$table->string('external_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}