<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('products_categories', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('products_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('options_categories', function(Blueprint $table) {
			$table->foreign('option_id')->references('id')->on('options')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('options_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('options_values', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('options_values', function(Blueprint $table) {
			$table->foreign('option_id')->references('id')->on('options')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('markets_brands', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('markets_brands', function(Blueprint $table) {
			$table->foreign('market_id')->references('id')->on('markets')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('products_images', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_brand_id_foreign');
		});
		Schema::table('products_categories', function(Blueprint $table) {
			$table->dropForeign('products_categories_product_id_foreign');
		});
		Schema::table('products_categories', function(Blueprint $table) {
			$table->dropForeign('products_categories_category_id_foreign');
		});
		Schema::table('options_categories', function(Blueprint $table) {
			$table->dropForeign('options_categories_option_id_foreign');
		});
		Schema::table('options_categories', function(Blueprint $table) {
			$table->dropForeign('options_categories_category_id_foreign');
		});
		Schema::table('options_values', function(Blueprint $table) {
			$table->dropForeign('options_values_product_id_foreign');
		});
		Schema::table('options_values', function(Blueprint $table) {
			$table->dropForeign('options_values_option_id_foreign');
		});
		Schema::table('markets_brands', function(Blueprint $table) {
			$table->dropForeign('markets_brands_brand_id_foreign');
		});
		Schema::table('markets_brands', function(Blueprint $table) {
			$table->dropForeign('markets_brands_market_id_foreign');
		});
		Schema::table('products_images', function(Blueprint $table) {
			$table->dropForeign('products_images_product_id_foreign');
		});
	}
}