<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'order';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function has_transaction()
    {
        return $this->hasOne('Transaction');
    }

    public function has_customer()
    {
        return $this->hasOne('Customer');
    }

}