<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCam2webInstancesTable extends Migration {

	public function up()
	{
		Schema::create('cam2web_instances', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('customer_name', 75)->nullable();
			$table->string('hostname', 255)->nullable();
			$table->string('site_url', 1024)->nullable();
			$table->integer('version_id');
			$table->string('ftp_hostname', 255)->nullable();
			$table->string('ftp_port')->nullable();
			$table->string('ftp_username')->nullable();
			$table->string('ftp_password', 255)->nullable();
			$table->string('full_url', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('cam2web_instances');
	}
}