<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->string('desc', 255);
			$table->float('price');
			$table->integer('avg_time')->nullable();
			$table->integer('salon_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}