<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlanOfferTable extends Migration {

	public function up()
	{
		Schema::create('plan_offer', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->char('offer_title');
			$table->integer('start_date');
			$table->integer('end_date');
			$table->integer('discount_perc_by_year');
			$table->integer('discount_val_by_year');
			$table->enum('flag_active', array('active', 'not_active'));
			$table->integer('user_id');
			$table->integer('discount_val_by_month');
			$table->integer('discount_perc_by_month');
		});
	}

	public function down()
	{
		Schema::drop('plan_offer');
	}
}