<?php

namespace ads;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Price extends Model 
{

    protected $table = 'ads_price';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('experiment_id', 'slot', 'collaboration', 'title_length', 'description_length');

    public function procedure()
    {
        return $this->belongsTo('Experiment');
    }

}