<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('firstname', 10);
			$table->string('lastname', 10);
			$table->string('username', 10);
			$table->string('email', 50);
			$table->integer('employeeID');
			$table->string('password', 255);
			$table->string('confirmation_code');
			$table->string('remember_token');
			$table->enum('status', array('0', '1'));
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}