<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Projects extends Eloquent {

	protected $table = 'projects';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function Repositories()
	{
		return $this->hasOne('Repositories', 'project_id');
	}

	public function Tasks()
	{
		return $this->hasMany('Tasks', 'project_id');
	}

	public function Wiki()
	{
		return $this->hasMany('Wiki', 'project_id');
	}

	public function User()
	{
		return $this->belongsToMany('Users', 'user_id')->withPivot('users_project','user_id');
	}

}