<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Attachments extends Model 
{

    protected $table = 'attachments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Tasks()
    {
        return $this->belongsTo('Tasks', 'task_id');
    }

    public function UploadedBy()
    {
        return $this->belongsTo('Users', 'user_id');
    }

}