<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Projects extends Model 
{

    protected $table = 'projects';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Repositories()
    {
        return $this->hasOne('Repositories', 'project_id');
    }

    public function Tasks()
    {
        return $this->hasMany('Tasks', 'project_id');
    }

    public function Wiki()
    {
        return $this->hasMany('Wiki', 'project_id');
    }

    public function User()
    {
        return $this->belongsToMany('Users', 'user_id')->withPivot('users_project','user_id');
    }

}