<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tasks extends Model 
{

    protected $table = 'tasks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function sprint()
    {
        return $this->belongsTo('Sprints');
    }

    public function Project()
    {
        return $this->belongsTo('Projects');
    }

    public function Comments()
    {
        return $this->hasMany('Comments', 'task_id');
    }

    public function TaskHistory()
    {
        return $this->hasMany('TaskHistory', 'task_id');
    }

}