<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRacksTable extends Migration {

	public function up()
	{
		Schema::create('racks', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('warehouse_id')->unsigned();
			$table->string('code', 50);
			$table->smallInteger('rows');
			$table->boolean('active');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('racks');
	}
}