<?php

namespace categories;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Categories extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function parent()
	{
		return $this->belongsTo('categories\Categories', 'parent_id');
	}

	public function product_categories()
	{
		return $this->hasMany('productCategories\ProductCategories', 'category_id');
	}

}