<?php

namespace warehouses;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Warehouses extends Eloquent {

	protected $table = 'warehouses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function store()
	{
		return $this->belongsTo('stores\Stores', 'store_id');
	}

	public function racks()
	{
		return $this->hasMany('racks\Racks', 'warehouse_id');
	}

}