<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'password', 'phone_number', 'date_of_birth', 'blood_type_id', 'last_donation', 'city_id');

	public function city()
	{
		return $this->hasOne('App\Models\City');
	}

	public function governorate()
	{
		return $this->morphToMany('App\Models\Governorate');
	}

	public function notification()
	{
		return $this->morphToMany('App\Models\Notification');
	}

	public function donation_request()
	{
		return $this->hasMany('App\Models\DonationRequest');
	}

	public function post()
	{
		return $this->morphToMany('App\Models\Post');
	}

	public function blood_type()
	{
		return $this->morphToMany('App\Models\BloodType');
	}

}