<?php

namespace App\Models;

class Clientables extends Eloquent {

	protected $table = 'clientables';
	public $timestamps = false;
	protected $fillable = array('clientable_id', 'clientable_type', 'seen');

	public function notification()
	{
		return $this->morphedByMany('App\Models\Notification')->withPivot('seen');
	}

	public function post()
	{
		return $this->morphedByMany('App\Models\Post');
	}

	public function governorate()
	{
		return $this->morphedByMany('App\Models\Governorate');
	}

	public function blood_type()
	{
		return $this->morphedByMany('App\Models\BloodType');
	}

}