<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $hidden = array('id', 'connect_type', 'social_id', 'email', 'email_hash', 'password', 'last_name', 'notify', 'ip_address', 'last_login_at', 'timestamps');

    public function entries()
    {
        return $this->hasMany('Entry');
    }

    public function aids()
    {
        return $this->hasMany('Aid');
    }

}