<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Destination extends Model 
{

    protected $table = 'destinations';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $hidden = array('campaign_id', 'airport_departure_id', 'airport_destination_id');

    public function entries()
    {
        return $this->hasMany('Entry', 'destination_id');
    }

    public function campaign()
    {
        return $this->belongsTo('Campaign');
    }

    public function locations()
    {
        return $this->hasMany('Location');
    }

    public function destination()
    {
        return $this->hasOne('Airport', 'id', 'airport_destination_id');
    }

    public function departure()
    {
        return $this->hasOne('Airport', 'id', 'airport_departure_id');
    }

}