<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('connect_type', array('email', 'twitter', 'facebook'));
			$table->string('social_id', 128)->nullable();
			$table->binary('email');
			$table->string('email_hash', 250)->unique();
			$table->string('password', 250)->nullable();
			$table->string('first_name', 128);
			$table->string('last_name', 128);
			$table->string('profile_picture', 250)->nullable();
			$table->boolean('notify')->nullable();
			$table->string('ip_address', 15);
			$table->datetime('last_login_at')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}