<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $hidden = array('id', 'connect_type', 'social_id', 'email', 'email_hash', 'password', 'last_name', 'notify', 'ip_address', 'last_login_at', 'timestamps');

	public function entries()
	{
		return $this->hasMany('Entry');
	}

	public function aids()
	{
		return $this->hasMany('Aid');
	}

}