<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntriesTable extends Migration {

	public function up()
	{
		Schema::create('entries', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('campaign_id')->unsigned();
			$table->integer('destination_id')->unsigned();
			$table->boolean('activated')->nullable();
			$table->decimal('coordinates');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('entries');
	}
}