<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCampaignsTable extends Migration {

	public function up()
	{
		Schema::create('campaigns', function(Blueprint $table) {
			$table->increments('id');
			$table->string('country', 128);
			$table->string('country_code', 3);
			$table->string('language_codes', 128);
			$table->string('currency', 10);
			$table->integer('winner_id')->unsigned()->nullable();
			$table->datetime('start_at');
			$table->datetime('end_at');
			$table->timestamps();
			$table->softDeletes();
			$table->boolean('active');
		});
	}

	public function down()
	{
		Schema::drop('campaigns');
	}
}