<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('parent_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('parent_categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('vendor_address_id')->references('id')->on('addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('delivery_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('product_combination_id')->references('id')->on('product_combinations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_offers', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('variations', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('variation_options', function(Blueprint $table) {
			$table->foreign('variation_id')->references('id')->on('variations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_variations_options', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_variations_options_values', function(Blueprint $table) {
			$table->foreign('variation_id')->references('id')->on('variations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_variations_options_values', function(Blueprint $table) {
			$table->foreign('product_variation_id')->references('id')->on('product_variations_options')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_stocks', function(Blueprint $table) {
			$table->foreign('product_combination_id')->references('id')->on('product_combinations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_combinations', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('sections')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('additional_information', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('additional_information', function(Blueprint $table) {
			$table->foreign('section_id')->references('id')->on('sections')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('additional_information', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_vendor_id_foreign');
		});
		Schema::table('parent_categories', function(Blueprint $table) {
			$table->dropForeign('parent_categories_category_id_foreign');
		});
		Schema::table('parent_categories', function(Blueprint $table) {
			$table->dropForeign('parent_categories_parent_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_vendor_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_vendor_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_address_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_vendor_address_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_delivery_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_order_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_product_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_product_combination_id_foreign');
		});
		Schema::table('product_offers', function(Blueprint $table) {
			$table->dropForeign('product_offers_product_id_foreign');
		});
		Schema::table('variations', function(Blueprint $table) {
			$table->dropForeign('variations_vendor_id_foreign');
		});
		Schema::table('variation_options', function(Blueprint $table) {
			$table->dropForeign('variation_options_variation_id_foreign');
		});
		Schema::table('product_variations_options', function(Blueprint $table) {
			$table->dropForeign('product_variations_options_product_id_foreign');
		});
		Schema::table('product_variations_options_values', function(Blueprint $table) {
			$table->dropForeign('product_variations_options_values_variation_id_foreign');
		});
		Schema::table('product_variations_options_values', function(Blueprint $table) {
			$table->dropForeign('product_variations_options_values_product_variation_id_foreign');
		});
		Schema::table('product_stocks', function(Blueprint $table) {
			$table->dropForeign('product_stocks_product_combination_id_foreign');
		});
		Schema::table('product_combinations', function(Blueprint $table) {
			$table->dropForeign('product_combinations_product_id_foreign');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->dropForeign('sections_parent_id_foreign');
		});
		Schema::table('additional_information', function(Blueprint $table) {
			$table->dropForeign('additional_information_user_id_foreign');
		});
		Schema::table('additional_information', function(Blueprint $table) {
			$table->dropForeign('additional_information_section_id_foreign');
		});
		Schema::table('additional_information', function(Blueprint $table) {
			$table->dropForeign('additional_information_vendor_id_foreign');
		});
	}
}