<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('vendor_id')->unsigned();
			$table->boolean('is_guest');
			$table->string('customer_email');
			$table->string('customer_first_name');
			$table->string('customer_last_name');
			$table->string('customer_phone');
			$table->integer('address_id')->unsigned();
			$table->integer('vendor_address_id')->unsigned();
			$table->enum('payment_method', array('cashondelivery', 'online'));
			$table->string('payment_id');
			$table->enum('order_type', array('cart', 'order'));
			$table->enum('status', array('pending', 'pending_payment', 'processing', 'completed', 'canceled', 'closed', 'fraud'));
			$table->string('total_item_count');
			$table->string('total_price');
			$table->string('sub_total');
			$table->string('discount_percent');
			$table->string('discount_amount');
			$table->string('tax_amount');
			$table->string('tax_percent');
			$table->string('shipping_amount');
			$table->integer('delivery_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}