<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('sku');
			$table->json('Name');
			$table->json('slug');
			$table->boolean('is_new');
			$table->boolean('is_featured');
			$table->enum('status', array('published', 'draft', 'inactive'));
			$table->json('description');
			$table->json('short_description');
			$table->json('meta_title');
			$table->string('meta_keywords');
			$table->json('meta_description');
			$table->decimal('price', 2);
			$table->string('width');
			$table->string('height');
			$table->string('depth');
			$table->string('weight');
			$table->enum('type', array('simple', 'configurable', 'virtual'));
			$table->string('stock');
			$table->integer('vendor_id')->unsigned();
			$table->enum('discount_type', array('percentage', 'no_discount', 'fixed'));
			$table->string('discount_percentage');
			$table->string('discount_fixed');
			$table->timestamps();
			$table->string('vat');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}