<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVariationsTable extends Migration {

	public function up()
	{
		Schema::create('variations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->integer('vendor_id')->unsigned();
			$table->string('unique_code');
			$table->enum('type', array('text', 'select', 'multi'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('variations');
	}
}