<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProviderTimingsTable extends Migration {

	public function up()
	{
		Schema::create('provider_timings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('provider_id')->unsigned();
			$table->time('from');
			$table->time('to');
			$table->boolean('is_off')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('provider_timings');
	}
}