<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProvidersTable extends Migration {

	public function up()
	{
		Schema::create('providers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('image');
			$table->string('name');
			$table->string('phone');
			$table->string('country_key');
			$table->string('email')->nullable();
			$table->text('bio');
			$table->integer('main_category_id')->unsigned()->nullable();
			$table->integer('subcategory_id')->unsigned()->nullable();
			$table->integer('city_id')->unsigned();
			$table->string('lat');
			$table->string('long');
			$table->text('map_desc')->nullable();
			$table->boolean('has_car')->default(0);
			$table->integer('persons_num')->nullable()->default('0');
			$table->string('bank_name');
			$table->string('bank_owner_name');
			$table->string('account_id');
			$table->string('iban');
			$table->integer('approval_status')->nullable()->default('0');
			$table->string('code')->nullable();
			$table->double('person_price')->nullable();
			$table->boolean('is_notify')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('providers');
	}
}