<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class LegalCase extends Eloquent {

	protected $table = 'legal_cases';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function MLRInfo()
	{
		return $this->hasOne('LegalCaseMLRInfo');
	}

	public function client()
	{
		return $this->hasMany('LegalCaseClient');
	}

	public function agent()
	{
		return $this->hasOne('LegalCaseAgent');
	}

	public function participant()
	{
		return $this->hasMany('LegalCaseMLRParticipant');
	}

	public function financial()
	{
		return $this->hasOne('MLRFinancial');
	}

	public function compliance()
	{
		return $this->hasOne('MLRCompliance');
	}

	public function specialCondition()
	{
		return $this->hasMany('MLRSpecialCondition');
	}

}