<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Cam extends Model 
{

    protected $table = 'cams';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function timestamps()
    {
        return $this->hasMany('Timestamp');
    }

    public function statistics()
    {
        return $this->hasMany('Statistics');
    }

    public function realm()
    {
        return $this->belongsTo('Realm');
    }

}