<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Statistics extends Eloquent {

	protected $table = 'statistics';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('cam_id', 'timestamp_id');

	public function cam()
	{
		return $this->belongsTo('Cam');
	}

	public function timestamp()
	{
		return $this->hasOne('Timestamp');
	}

}