<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Cam extends Eloquent {

	protected $table = 'cams';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function timestamps()
	{
		return $this->hasMany('Timestamp');
	}

	public function statistics()
	{
		return $this->hasMany('Statistics');
	}

	public function realm()
	{
		return $this->belongsTo('Realm');
	}

}