<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'user';
    public $timestamps = true;

    public function profile()
    {
        return $this->hasOne('App\User', 'user_id');
    }

    public function banks()
    {
        return $this->hasMany('Bank', 'user_id');
    }

    public function address()
    {
        return $this->hasMany('Address', 'user_id');
    }

    public function clients()
    {
        return $this->hasMany('Client', 'user_id');
    }

    public function category()
    {
        return $this->hasMany('User', 'user_id');
    }

}