<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceTable extends Migration {

	public function up()
	{
		Schema::create('invoice', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned();
			$table->integer('type');
			$table->date('date');
			$table->date('due_date');
			$table->string('number');
			$table->boolean('status');
			$table->integer('sub_total');
			$table->integer('discount');
			$table->integer('tax');
			$table->integer('amount_paid');
			$table->integer('total');
			$table->text('notes');
			$table->text('terms');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('invoice');
	}
}