<?php

namespace TargetedCustomer;

use Illuminate\Database\Eloquent\Model;

class TargetedCustomer extends Model 
{

    protected $table = 'targeted_customers';
    public $timestamps = true;

    public function specialization()
    {
        return $this->belongsTo('Specialization');
    }

    public function contactPersons()
    {
        return $this->hasMany('ContactPerson');
    }

    public function status()
    {
        return $this->hasOne('Status');
    }

    public function targetedCustomersPhones()
    {
        return $this->hasMany('TargetedCustomersPhone');
    }

    public function stage()
    {
        return $this->hasOne('Target_customer_stage');
    }

    public function city()
    {
        return $this->belongsTo('City');
    }

}