<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_az');
    protected $visible = array('category_id', 'name_az');

    public function quantities()
    {
        return $this->hasMany('Quantity');
    }

    public function category()
    {
        return $this->belongsTo('Category');
    }

    public function features()
    {
        return $this->belongsToMany('Feature', 'products_features')->withPivot('unit_id', 'value');
    }

    public function photos()
    {
        return $this->hasMany('Photo');
    }

    public function attributes()
    {
        return $this->belongsToMany('Attribute', 'products_attributes')->withPivot('price_impact', 'price_total');
    }

}