<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('email', 255)->unique();
			$table->string('password', 60);
			$table->string('remember_token', 100);
			$table->boolean('active')->default(0);
			$table->timestamps();
			$table->timestamp('last_login');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}